<?php
// Inicia a sessão para verificar o login do usuário
session_start();
if (!isset($_SESSION['usuario'])) {
    header("Location: login.php");
    exit();
}
$nome_usuario = $_SESSION['usuario']['nome'] ?? 'Usuário';

// Configurações de conexão com o banco de dados
$servidor = "localhost";
$usuario_bd = "root";
$senha_bd = "";
$nome_bd = "sismag";

// Conexão com o banco de dados
$conn = new mysqli($servidor, $usuario_bd, $senha_bd, $nome_bd);
if ($conn->connect_error) {
    die("Falha na conexão: " . $conn->connect_error);
}
$conn->set_charset("utf8");

// ID do usuário logado (professor)
$destinatario_id = $_SESSION['usuario']['id'] ?? 0;

// Consulta para buscar mensagens para o usuário logado
// CORREÇÃO: A consulta foi ajustada para usar as colunas da tabela que você forneceu.
// Assumimos que a coluna 'destinatario_id' existe, pois é necessária para o filtro.
$sql = "SELECT id, id_autor, nome_autor, mensagem, data_envio FROM mensagens_prof WHERE destinatario_id = ?";
$stmt = $conn->prepare($sql);
if ($stmt === false) {
    die("Erro na preparação da consulta: " . $conn->error);
}
$stmt->bind_param("i", $destinatario_id);
$stmt->execute();
$resultado = $stmt->get_result();

$mensagens = [];
if ($resultado->num_rows > 0) {
    while ($row = $resultado->fetch_assoc()) {
        $mensagens[] = $row;
    }
}

$stmt->close();
$conn->close();
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mensagens - SISMAG</title>
    <!-- Adicione seus estilos CSS aqui -->
    <style>
        body { font-family: Arial, sans-serif; background-color: #f4f4f4; margin: 0; padding: 20px; }
        .container { max-width: 900px; margin: auto; background: #fff; padding: 20px; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        h2 { color: #333; }
        .mensagem-list { margin-top: 20px; }
        .mensagem-list table { width: 100%; border-collapse: collapse; }
        .mensagem-list th, .mensagem-list td { padding: 12px 15px; border-bottom: 1px solid #ddd; text-align: left; }
        .mensagem-list th { background-color: #f2f2f2; color: #555; }
        .mensagem-list tr:hover { background-color: #f9f9f9; }
        .mensagem-list .nao-lida { font-weight: bold; }
        .no-messages { text-align: center; color: #888; padding: 50px; }
    </style>
</head>
<body>

<div class="container">
    <h2>Caixa de Entrada</h2>
    <div class="mensagem-list">
        <?php if (!empty($mensagens)): ?>
            <table>
                <thead>
                    <tr>
                        <th>Remetente</th>
                        <th>Mensagem (Assunto)</th>
                        <th>Data</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($mensagens as $msg): ?>
                        <tr>
                            <td><a href="ver_mensagem.php?id=<?= $msg['id'] ?>"><?= htmlspecialchars($msg['nome_autor']) ?></a></td>
                            <td><a href="ver_mensagem.php?id=<?= $msg['id'] ?>"><?= htmlspecialchars(substr($msg['mensagem'], 0, 50)) ?>...</a></td>
                            <td><a href="ver_mensagem.php?id=<?= $msg['id'] ?>"><?= date('d/m/Y H:i', strtotime($msg['data_envio'])) ?></a></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php else: ?>
            <p class="no-messages">Você não tem novas mensagens.</p>
        <?php endif; ?>
    </div>
</div>

</body>
</html>
